/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import com.aptana.editor.php.internal.indexer.ElementsIndexingUtils;
import com.aptana.editor.php.internal.indexer.FunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.IEntryFilter;
import com.aptana.editor.php.internal.indexer.VariablePHPEntryValue;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org2.eclipse.php.core.compiler.PHPFlags;

public class AccessModifierEntryFilter
implements IEntryFilter {
    private Set<String> rootClasses;
    private final boolean isPackageVisibility;

    public AccessModifierEntryFilter(Set<String> rootClasses, boolean isPackageVisibility) {
        this.rootClasses = rootClasses;
        this.isPackageVisibility = isPackageVisibility;
    }

    @Override
    public Set<IElementEntry> filter(Collection<IElementEntry> toFilter) {
        LinkedHashSet<IElementEntry> result = new LinkedHashSet<IElementEntry>();
        for (IElementEntry entry : toFilter) {
            if (!this.accept(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    private static String getClassName(IElementEntry entry) {
        return ElementsIndexingUtils.getFirstNameInPath(entry.getEntryPath());
    }

    protected boolean accept(IElementEntry entry) {
        Object value = entry.getValue();
        if (!(value instanceof FunctionPHPEntryValue) && !(value instanceof VariablePHPEntryValue)) {
            return true;
        }
        int modifiers = ((AbstractPHPEntryValue)value).getModifiers();
        return this.isPackageVisibility ? this.rootClasses.contains(AccessModifierEntryFilter.getClassName(entry)) && (PHPFlags.isPublic((int)modifiers) || PHPFlags.isProtected((int)modifiers)) : this.rootClasses.contains(AccessModifierEntryFilter.getClassName(entry)) || PHPFlags.isPublic((int)modifiers) || PHPFlags.isProtected((int)modifiers);
    }
}

